/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.util.HardwareServerMessage;
import com.ibm.hsc.common.util.PIParseResponse;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt8;

public class FspHardwareServerInfo {
    private int mMajorVersion;
    private int mMinorVersion;
    private int mBuildYear;
    private int mBuildWeek;
    private String mHmcMtms;
    private static final String MAJOR_VER = "MAJOR_VER";
    private static final String MINOR_VER = "MINOR_VER";
    private static final String BLD_YEAR = "BLD_YEAR";
    private static final String BLD_WEEK = "BLD_WEEK";
    private static final String MTMS = "MTMS";
    private static final String HARDWARE_SERVER_VERSION_MTMS_QUERY = "HARDWARE_SERVER_VERSION_MTMS_QUERY";

    public FspHardwareServerInfo(HardwareServerMessage hardwareServerMessage) {
        this.loadData(hardwareServerMessage.getPayload());
    }

    private void loadData(byte[] byArray) {
        try {
            Hashtable hashtable = PIParseResponse.parseByCmd(HARDWARE_SERVER_VERSION_MTMS_QUERY, byArray);
            System.out.println("resp: " + hashtable);
            this.mMajorVersion = ((UnsignedInt8)hashtable.get(MAJOR_VER)).intValue();
            this.mMinorVersion = ((UnsignedInt8)hashtable.get(MINOR_VER)).intValue();
            this.mBuildYear = ((UnsignedInt8)hashtable.get(BLD_YEAR)).intValue();
            this.mBuildWeek = ((UnsignedInt8)hashtable.get(BLD_WEEK)).intValue();
            this.mHmcMtms = (String)hashtable.get(MTMS);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getMajorVersion() {
        return this.mMajorVersion;
    }

    public int getMinorVersion() {
        return this.mMinorVersion;
    }

    public int getBuildYear() {
        return this.mBuildYear;
    }

    public int getBuildWeek() {
        return this.mBuildWeek;
    }

    public String getHmcMtms() {
        return this.mHmcMtms;
    }
}

